/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary.lists;

import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureFilterList;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureList;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.CreatureType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.Tessellator;

public class CreatureTypeList
extends CreatureFilterList {
    private Map<Integer, CreatureType> creatureTypeList = new HashMap<Integer, CreatureType>();

    public CreatureTypeList(BeastiaryScreen parentGui, int width, int height, int top, int bottom, int x) {
        super(parentGui, width, height, top, bottom, x, 16);
        this.refreshList();
    }

    @Override
    public void refreshList() {
        this.creatureTypeList.clear();
        int groupIndex = 0;
        ArrayList<CreatureType> creatureTypes = new ArrayList<CreatureType>();
        creatureTypes.addAll(CreatureManager.getInstance().creatureTypes.values());
        creatureTypes.sort(Comparator.comparing(CreatureType::getTitle));
        for (CreatureType creatureType : creatureTypes) {
            if (this.parentGui.playerExt.beastiary.getCreaturesDiscovered(creatureType) <= 0) continue;
            this.creatureTypeList.put(groupIndex++, creatureType);
        }
    }

    @Override
    protected int getSize() {
        return this.creatureTypeList.size();
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick) {
        this.parentGui.playerExt.selectedCreatureType = this.creatureTypeList.get(index);
        super.elementClicked(index, doubleClick);
    }

    @Override
    protected boolean isSelected(int index) {
        return this.parentGui.playerExt.selectedCreatureType != null && this.parentGui.playerExt.selectedCreatureType.equals(this.creatureTypeList.get(index));
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    protected void drawSlot(int index, int boxRight, int boxTop, int boxBottom, Tessellator tessellator) {
        CreatureType creatureType = this.creatureTypeList.get(index);
        if (creatureType == null) {
            return;
        }
        this.parentGui.getFontRenderer().func_175065_a(creatureType.getTitle(), (float)(this.left + 4), (float)(boxTop + 2), 0xFFFFFF, true);
    }

    @Override
    public boolean canListCreature(CreatureInfo creatureInfo, CreatureList.Type listType) {
        if (this.parentGui.playerExt.selectedCreatureType == null || creatureInfo == null) {
            return false;
        }
        return creatureInfo.creatureType == this.parentGui.playerExt.selectedCreatureType;
    }
}

